/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.Animation;
import Handlers.Options;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public class MenuObject {
    protected double x;
    protected double y;
    protected int width;
    protected int height;
    protected int cwidth;
    protected int cheight;
    protected int[] cwidths = new int[10];
    protected int[] cheights = new int[10];
    protected int tweakx;
    protected int tweaky;
    protected Animation animation = new Animation();
    protected int currentAction;
    protected int previousAction;
    protected int currRow;
    protected int currCol;
    protected double xdest;
    protected double ydest;
    protected double xtemp;
    protected double ytemp;
    protected boolean topLeft;
    protected boolean topRight;
    protected boolean bottomLeft;
    protected boolean bottomRight;

    public boolean intersects(MenuObject m, int i, int spacingx, int spacingy) {
        Rectangle r1 = this.getRectangle(i, spacingx, spacingy);
        Rectangle r2 = m.getRectangle();
        return r1.intersects(r2);
    }

    public Rectangle getRectangle() {
        return new Rectangle((int)this.x, (int)this.y, this.cwidth, this.cheight);
    }

    public Rectangle getRectangle(int i, int spacingx, int spacingy) {
        return new Rectangle((int)this.x - this.cwidths[i] / 2 + i * spacingx, (int)this.y - this.cheights[i] / 2 + i * spacingy, this.cwidths[i], this.cheights[i]);
    }

    public void setTweakx(int i) {
        this.tweakx = i;
    }

    public void setTweaky(int i) {
        this.tweaky = i;
    }

    public int getx() {
        return (int)this.x;
    }

    public int gety() {
        return (int)this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCWidth() {
        return this.cwidth;
    }

    public int getCHeight() {
        return this.cheight;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void draw(Graphics2D g) {
        g.drawImage((Image)this.animation.getImage(), (int)this.x + this.tweakx, (int)this.y + this.tweaky, null);
        if (Options.getOption(4)) {
            g.setColor(Color.MAGENTA);
            g.drawRect((int)this.x, (int)this.y, this.cwidth, this.cheight);
        }
    }
}

